const express = require('express');
const cookieParser = require('cookie-parser');
const jwt = require('jsonwebtoken');
const db = require('./db.js');
const auth = require('./auth.js');
const { verify } = require('jsonwebtoken');

const app = express();
app.use(express.json());
app.use(express.urlencoded());
app.use(cookieParser());
app.use("/api/auth", auth);
app.use(express.static('public'));

function verifyToken(req, res, next){
    const token = req.cookie['token'];
    if(token){        
        jwt.verify(token, "un segreto", (err, payload) => {
            if(err){
                res.status(403).send("Errore");
            } else {
                next();
            }
        });
    } else {
        res.status(403).send("Errore");
    }
}


app.get("/books", async (req, res) => {
    const mongo = await db.connect2db();
    const cursor = await mongo.collection("books").find();
    const books = await cursor.toArray();
    res.json(books);
});
app.get("/books/:idBooks", async (req, res) => {
    let query = {id: parseInt(req.params.idBooks)};
    const mongo = await db.connect2db();
    const book = await mongo.collection('books').findOne(query);
    res.json(book);
});
app.post("/books", verifyToken, async (req, res) => {
    const mongo = await db.connect2db();
    let title = req.body.title;
    let id = parseInt(req.body.id);
    let book = { title, id };
    await mongo.collection('books').insertOne(book);
    res.json(book);

});
app.put("/books/:idBooks", async (req, res) => {
    const mongo = await db.connect2db();
    let title = req.body.title;
    let id = parseInt(req.params.idBooks);
    let book = { title, id };
    let query = { id: id};
    await mongo.collection('books').updateOne(query, book);
    res.json(book);
});
app.delete("/books/:idBooks", async (req, res) => {
    const mongo = await db.connect2db();
    let id = parseInt(req.params.idBooks);
    let book = { title, id };
    let query = { id: id};
    await mongo.collection('books').deleteOne(query);
    res.json(book);
});

app.use(verifyToken);
app.use(express.static('private'));

app.listen(3000, () => {

});