const { MongoClient } = require('mongodb');
const URI = "mongodb://mongohost";
let cachedDB;

module.exports = {
    connect2db: async () => {
        if(cachedDB){
            console.log("Recupero connessione esistente");
            return cachedDB;
        }
        try{
            console.log("Creo nuova connessione");
            const client = await MongoClient.connect(URI);
            cachedDB = client.db("books");
            return cachedDB;
        } catch(err){
            console.log("Errore!");
            return null;
        }
    }
}